function [Mcc,Ncc] = bfor_endogenous_ms_solver_matrices_cc(nderivs, that, Pmatss, H , G, G2)
% 
% Returns the matrices Mcc and Nccc for solving the second order derivative
%   with respect to chi, chi
% 
% Updated 2020/12
% Benigno, Foerster, Otrok, and Rebucci
% % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % %
% 
%  INPUTS
%  nderivs  = structure with elements of the first and second derivatives
%               of f with respect to vars, and first derivatives of Pmat
%               with respect to vars; both evaluated at steady state  
%  that     = (ntheta x ns matrix) of theta-hat, the deviation of theta_s 
%               from thetabar
%  Pmatss   = (ns x ns) matrix of the transition matrix at steady state
%  H        = (nx x (nx+ne+1) x ns) array for first-order solution for the 
%               predetermined variables, H(i,j,s) is the response of x(i) 
%               to state(j) given regime s, state=[xlag;epsilon;chi]
%  G        = (ny x (nx+ne+1) x ns) array for first-order solution for the 
%               non-predetermined variables, G(i,j,s) is the response of 
%               y(i) to state(j) given regime s, state=[xlag;epsilon;chi]
%  G2       = (ny x (nx+ne+1)^2 x ns) array for second-order solution for 
%               the non-predetermined variables, G2(i,j,s) is the response 
%               of y(i) to the j-element of kron(state,state) conditional 
%               on regime s
%  
%  OUTPUTS
%   Mcc     = {ns x ns) cell of derivative coefficients for solving the
%               system
%   Ncc     = {ns x ns) cell of constants for solving the system
% 
% % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % %



% -- Other Setup -- %
ny  = size(G,1);
nx  = size(H,1);
ne  = size(H,2)-nx-1;
ns  = length(Pmatss);
nt  = size(that,1);
n   = nx + ny;
Mcc = cell(ns,ns);
Ncc = cell(ns,ns);

dPy = nderivs.dPy;

for s = 1:ns
    for sp = 1:ns
        dfyp          = nderivs.dfyp{sp,s};
        dfy           = nderivs.dfy{sp,s};
        dfx           = nderivs.dfx{sp,s};
        dftp          = nderivs.dftp{sp,s};
        dft           = nderivs.dft{sp,s};
        dfypyp        = nderivs.dfypyp{sp,s};
        dfypy         = nderivs.dfypy{sp,s};
        dfypx         = nderivs.dfypx{sp,s};
        dfypep        = nderivs.dfypep{sp,s};
        dfyptp        = nderivs.dfyptp{sp,s};
        dfypt         = nderivs.dfypt{sp,s};
        dfyy          = nderivs.dfyy{sp,s};
        dfyx          = nderivs.dfyx{sp,s};
        dfytp         = nderivs.dfytp{sp,s};
        dfyt          = nderivs.dfyt{sp,s};
        dfxx          = nderivs.dfxx{sp,s};
        dfxtp         = nderivs.dfxtp{sp,s};
        dfxt          = nderivs.dfxt{sp,s};
        dfepep        = nderivs.dfepep{sp,s};
        dftptp        = nderivs.dftptp{sp,s};
        dftpt         = nderivs.dftpt{sp,s};
        dftt          = nderivs.dftt{sp,s};
 
        Mcc{sp,s} = Pmatss(s,sp)*[dfx+dfyp*G(:,1:nx,sp) dfy dfyp];
        Ncc{sp,s} = zeros(n,1);
        for aa = 1:n
            loc = aa;
            Ncc{sp,s}(loc) = 0;          
            for ii = 1:ny  
                Ncc{sp,s}(loc) = Ncc{sp,s}(loc) ...
                    + Pmatss(s,sp)*(reshape(dfypyp(aa,ii,:),1,[])*(G(:,1:nx,sp)*H(:,nx+ne+1,s) + G(:,nx+ne+1,sp)) + reshape(dfypy(aa,ii,:),1,[])*G(:,nx+ne+1,s) + reshape(dfypx(aa,ii,:),1,[])*H(:,nx+ne+1,s) + reshape(dfyptp(aa,ii,:),1,[])*that(:,sp) + reshape(dfypt(aa,ii,:),1,[])*that(:,s))*(G(ii,1:nx,sp)*H(:,nx+ne+1,s) + G(ii,nx+ne+1,sp)) ...
                    + Pmatss(s,sp)*(reshape(dfypy(aa,:,ii),1,[])*(G(:,1:nx,sp)*H(:,nx+ne+1,s)  + G(:,nx+ne+1,sp)) + reshape(dfyy(aa,ii,:),1,[])*G(:,nx+ne+1,s)  + reshape(dfyx(aa,ii,:),1,[])*H(:,nx+ne+1,s)  + reshape(dfytp(aa,ii,:),1,[])*that(:,sp)  + reshape(dfyt(aa,ii,:),1,[])*that(:,s))*G(ii,nx+ne+1,s);
            end    
            for ii = 1:nx
                Ncc{sp,s}(loc) = Ncc{sp,s}(loc) ...
                	+ Pmatss(s,sp)*(reshape(dfypx(aa,:,ii),1,[])*(G(:,1:nx,sp)*H(:,nx+ne+1,s) + G(:,nx+ne+1,sp)) + reshape(dfyx(aa,:,ii),1,[])*G(:,nx+ne+1,s) + reshape(dfxx(aa,:,ii),1,[])*H(:,nx+ne+1,s) + reshape(dfxtp(aa,ii,:),1,[])*that(:,sp) + reshape(dfxt(aa,ii,:),1,[])*that(:,s))*H(ii,nx+ne+1,s) ...
                    + Pmatss(s,sp)*(dfyp(aa,:)*(G2(:,(ii-1)*(nx+ne+1)+1:(ii-1)*(nx+ne+1)+nx,sp)*H(ii,nx+ne+1,s)*H(:,nx+ne+1,s) + 2*G2(:,ii*(nx+ne+1),sp)*H(ii,nx+ne+1,s))); 
            end
            for ii = 1:nt
                Ncc{sp,s}(loc) = Ncc{sp,s}(loc) ...
                    + Pmatss(s,sp)*(reshape(dfyptp(aa,:,ii),1,[])*(G(:,1:nx,sp)*H(:,nx+ne+1,s) + G(:,nx+ne+1,sp)) + reshape(dfytp(aa,:,ii),1,[])*G(:,nx+ne+1,s) + reshape(dfxtp(aa,:,ii),1,[])*H(:,nx+ne+1,s) + reshape(dftptp(aa,:,ii),1,[])*that(:,sp) + reshape(dftpt(aa,ii,:),1,[])*that(:,s))*that(ii,sp) ...
                    + Pmatss(s,sp)*(reshape(dfypt(aa,:,ii),1,[])*(G(:,1:nx,sp)*H(:,nx+ne+1,s) + G(:,nx+ne+1,sp))  + reshape(dfyt(aa,:,ii),1,[])*G(:,nx+ne+1,s)  + reshape(dfxt(aa,:,ii),1,[])*H(:,nx+ne+1,s)  + reshape(dftpt(aa,:,ii),1,[])*that(:,sp)  + reshape(dftt(aa,:,ii),1,[])*that(:,s))*that(ii,s);
            end 
            for ii = 1:ne
                Ncc{sp,s}(loc) = Ncc{sp,s}(loc) ...
                    + Pmatss(s,sp)*(2*reshape(dfypep(aa,:,ii),1,[])*G(:,nx+ii,sp) + dfyp(aa,:)*G2(:,(nx+ne+1)*(nx+ii-1)+nx+ii,sp) + dfepep(aa,ii,ii));           
                for jj = 1:ny
                    Ncc{sp,s}(loc) = Ncc{sp,s}(loc) ...
                        + Pmatss(s,sp)*(reshape(dfypyp(aa,jj,:),1,[])*G(jj,nx+ii,sp)*G(:,nx+ii,sp));
                end
            end
            Ncc{sp,s}(loc) = Ncc{sp,s}(loc) ...
                + 2*shiftdim(dPy(s,sp,:),1)*G(:,nx+ne+1,s)*(dfyp(aa,:)*(G(:,1:nx,sp)*H(:,nx+ne+1,s) + G(:,nx+ne+1,sp)) + dfy(aa,:)*G(:,nx+ne+1,s) + dfx(aa,:)*H(:,nx+ne+1,s) + dftp(aa,:)*that(:,sp) + dft(aa,:)*that(:,s));
        end
    end
end